#!/usr/bin/zsh

# ==== Configuration ====
SABNZBD_HOST="" # IP or FQDN
API_KEY="" # API key
HTTP_SCHEME="" # http or https

# ==== Extract Job IDs ====
JOB_IDS=($(curl -s "$HTTP_SCHEME://$SABNZBD_HOST/sabnzbd/api?apikey=$API_KEY&mode=queue&output=json" | jq -r '.queue.slots[].nzo_id'))

# ==== Pause Each Job ====
for ID in $JOB_IDS; do
    curl -s "$HTTP_SCHEME://${SABNZBD_HOST}/sabnzbd/api?apikey=${API_KEY}&mode=queue&name=pause&value=$ID" > /dev/null
    echo "Paused job: $ID"
done

echo "All queue items individually paused."