#!/usr/bin/bash
set -euo pipefail

TMP_JSON_FILE=/tmp/todoist.json.tmp
TMP_ALL_LABELS_FILE=/tmp/all.labels.tmp
TMP_USED_LABELS_FILE=/tmp/used.labels.tmp
TMP_UNUSED_LABELS_FILE=/tmp/unused.labels.tmp
TMP_UNUSED_LABEL_IDS_FILE=/tmp/unused.label.ids.tmp


if [[ -z "${TODOIST_TOKEN:-}" ]]; then
  echo "Error: set TODOIST_TOKEN to your Todoist API token" >&2
  exit 1
fi

curl https://api.todoist.com/api/v1/sync \
    -H "Authorization: Bearer $TODOIST_TOKEN" \
    -d sync_token='*' \
    -d resource_types='["items", "labels"]' \
    > $TMP_JSON_FILE

cat $TMP_JSON_FILE \
    | jq -r '.labels[].name' \
    | sort \
    > $TMP_ALL_LABELS_FILE

cat $TMP_JSON_FILE \
    | jq -r '.items[].labels[]' \
    | uniq \
    | sort \
    > $TMP_USED_LABELS_FILE

comm -3 $TMP_ALL_LABELS_FILE $TMP_USED_LABELS_FILE > $TMP_UNUSED_LABELS_FILE

while IFS= read -r name; do
	jq -r --arg name "$name" '.labels[] | select(.name == $name) | .id' $TMP_JSON_FILE
done < $TMP_UNUSED_LABELS_FILE > $TMP_UNUSED_LABEL_IDS_FILE

while IFS= read -r id; do
  if [ -z "$id" ]; then
    continue
  fi
  echo "Processing ID: $id"
    curl https://api.todoist.com/api/v1/sync \
        -H "Authorization: Bearer $TODOIST_TOKEN" \
        -d commands='[
        {
            "type": "label_delete",
            "uuid": "'"$(uuidgen)"'",
            "args": {
                "id": "'"$id"'",
                "cascade": "none"
            }
        }]'
done < $TMP_UNUSED_LABEL_IDS_FILE

rm $TMP_JSON_FILE
rm $TMP_ALL_LABELS_FILE
rm $TMP_USED_LABELS_FILE
rm $TMP_UNUSED_LABELS_FILE
rm $TMP_UNUSED_LABEL_IDS_FILE
